/*
 * Decompiled with CFR 0.152.
 */
package com.sun.star.lib.uno.bridges.java_remote;

import com.sun.star.bridge.XBridge;
import com.sun.star.lib.uno.Proxy;
import com.sun.star.lib.uno.bridges.java_remote.RequestHandler;
import com.sun.star.lib.util.AsynchronousFinalizer;
import com.sun.star.uno.IQueryInterface;
import com.sun.star.uno.Type;
import com.sun.star.uno.UnoRuntime;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;

final class ProxyFactory {
    private static final Method METHOD_EQUALS;
    private static final Method METHOD_HASH_CODE;
    private static final Method METHOD_TO_STRING;
    private static final Method METHOD_QUERY_INTERFACE;
    private static final Method METHOD_IS_SAME;
    private static final Method METHOD_GET_OID;
    private static final Object debugCountLock;
    private static int debugCount;
    private final RequestHandler requestHandler;
    private final XBridge bridge;

    public ProxyFactory(RequestHandler requestHandler, XBridge bridge) {
        this.requestHandler = requestHandler;
        this.bridge = bridge;
    }

    public Object create(String oid, Type type) {
        return java.lang.reflect.Proxy.newProxyInstance(this.getClass().getClassLoader(), new Class[]{Proxy.class, IQueryInterface.class, type.getZClass()}, (InvocationHandler)new Handler(oid, type));
    }

    public boolean isProxy(Object obj) {
        if (java.lang.reflect.Proxy.isProxyClass(obj.getClass())) {
            InvocationHandler h = java.lang.reflect.Proxy.getInvocationHandler(obj);
            return h instanceof Handler && ((Handler)h).matches(this);
        }
        return false;
    }

    public static XBridge getBridge(Object obj) {
        InvocationHandler h;
        if (java.lang.reflect.Proxy.isProxyClass(obj.getClass()) && (h = java.lang.reflect.Proxy.getInvocationHandler(obj)) instanceof Handler) {
            return ((Handler)h).getBridge();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static int getDebugCount() {
        Object object = debugCountLock;
        synchronized (object) {
            return debugCount;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void incrementDebugCount() {
        Object object = debugCountLock;
        synchronized (object) {
            ++debugCount;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void decrementDebugCount() {
        Object object = debugCountLock;
        synchronized (object) {
            --debugCount;
        }
    }

    static {
        try {
            METHOD_EQUALS = Object.class.getMethod("equals", Object.class);
            METHOD_HASH_CODE = Object.class.getMethod("hashCode", null);
            METHOD_TO_STRING = Object.class.getMethod("toString", null);
            METHOD_QUERY_INTERFACE = IQueryInterface.class.getMethod("queryInterface", Type.class);
            METHOD_IS_SAME = IQueryInterface.class.getMethod("isSame", Object.class);
            METHOD_GET_OID = IQueryInterface.class.getMethod("getOid", null);
        }
        catch (NoSuchMethodException e) {
            throw new ExceptionInInitializerError(e);
        }
        debugCountLock = new Object();
        debugCount = 0;
    }

    private final class Handler
    implements InvocationHandler {
        private final String oid;
        private final Type type;
        private int dummy = 0;

        public Handler(String oid, Type type) {
            this.oid = oid;
            this.type = type;
            ProxyFactory.incrementDebugCount();
        }

        public boolean matches(ProxyFactory factory) {
            return ProxyFactory.this == factory;
        }

        public XBridge getBridge() {
            return ProxyFactory.this.bridge;
        }

        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            if (method.equals(METHOD_EQUALS) || method.equals(METHOD_IS_SAME)) {
                return args[0] != null && this.oid.equals(UnoRuntime.generateOid(args[0]));
            }
            if (method.equals(METHOD_HASH_CODE)) {
                return this.oid.hashCode();
            }
            if (method.equals(METHOD_TO_STRING)) {
                return "[Proxy:" + System.identityHashCode(proxy) + "," + this.oid + "," + this.type + "]";
            }
            if (method.equals(METHOD_QUERY_INTERFACE)) {
                return args[0].equals(this.type) ? proxy : this.request("queryInterface", args);
            }
            if (method.equals(METHOD_GET_OID)) {
                return this.oid;
            }
            return this.request(method.getName(), args);
        }

        protected void finalize() {
            AsynchronousFinalizer.add(new AsynchronousFinalizer.Job(){

                public void run() throws Throwable {
                    try {
                        Handler.this.request("release", null);
                    }
                    finally {
                        ProxyFactory.decrementDebugCount();
                    }
                }
            });
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Object request(String operation, Object[] args) throws Throwable {
            Object res = ProxyFactory.this.requestHandler.sendRequest(this.oid, this.type, operation, args);
            Handler handler = this;
            synchronized (handler) {
                ++this.dummy;
            }
            return res;
        }
    }
}

