/*
 * Decompiled with CFR 0.152.
 */
package com.sun.star.lib.uno.helper;

import com.sun.star.lang.IllegalArgumentException;
import com.sun.star.lang.XInitialization;
import com.sun.star.lang.XServiceInfo;
import com.sun.star.lang.XSingleComponentFactory;
import com.sun.star.lib.uno.helper.ComponentBase;
import com.sun.star.registry.InvalidRegistryException;
import com.sun.star.registry.XRegistryKey;
import com.sun.star.uno.RuntimeException;
import com.sun.star.uno.UnoRuntime;
import com.sun.star.uno.XComponentContext;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;

public class Factory
extends ComponentBase
implements XSingleComponentFactory,
XServiceInfo {
    private static final boolean DEBUG = false;
    private final String m_impl_name;
    private final String[] m_supported_services;
    private final Class<?> m_impl_class;
    private Method m_method;
    private Constructor m_ctor;

    public static XSingleComponentFactory createComponentFactory(Class impl_class, String impl_name, String[] supported_services) throws RuntimeException {
        return new Factory(impl_class, impl_name, supported_services);
    }

    public static XSingleComponentFactory createComponentFactory(Class impl_class, String[] supported_services) throws RuntimeException {
        return Factory.createComponentFactory(impl_class, impl_class.getName(), supported_services);
    }

    public static boolean writeRegistryServiceInfo(String impl_name, String[] supported_services, XRegistryKey xKey) {
        try {
            XRegistryKey xNewKey = xKey.createKey("/" + impl_name + "/UNO/SERVICES");
            for (int nPos = 0; nPos < supported_services.length; ++nPos) {
                xNewKey.createKey(supported_services[nPos]);
            }
            return true;
        }
        catch (InvalidRegistryException invalidRegistryException) {
            return false;
        }
    }

    private Factory(Class impl_class, String impl_name, String[] supported_services) {
        this.m_impl_name = impl_name;
        this.m_supported_services = supported_services;
        this.m_impl_class = impl_class;
        this.m_method = null;
        this.m_ctor = null;
        Class[] params = new Class[]{XComponentContext.class};
        try {
            this.m_method = this.m_impl_class.getMethod("__create", params);
            int mod = this.m_method.getModifiers();
            if (!(this.m_method.getReturnType().equals(Object.class) && Modifier.isStatic(mod) && Modifier.isPublic(mod))) {
                this.m_method = null;
            }
        }
        catch (Exception exc) {
            // empty catch block
        }
        if (null == this.m_method) {
            try {
                this.m_ctor = this.m_impl_class.getConstructor(params);
            }
            catch (Exception exc) {
                // empty catch block
            }
        }
    }

    private Object instantiate(XComponentContext xContext) throws com.sun.star.uno.Exception {
        try {
            if (null != this.m_method) {
                return this.m_method.invoke(null, xContext);
            }
            if (null != this.m_ctor) {
                return this.m_ctor.newInstance(xContext);
            }
            return this.m_impl_class.newInstance();
        }
        catch (InvocationTargetException exc) {
            Throwable targetException = exc.getTargetException();
            if (targetException instanceof java.lang.RuntimeException) {
                throw (java.lang.RuntimeException)targetException;
            }
            if (targetException instanceof RuntimeException) {
                throw (RuntimeException)targetException;
            }
            if (targetException instanceof com.sun.star.uno.Exception) {
                throw (com.sun.star.uno.Exception)targetException;
            }
            throw new com.sun.star.uno.Exception(targetException, targetException.getMessage(), this);
        }
        catch (IllegalAccessException exc) {
            throw new RuntimeException(exc, exc.getMessage(), this);
        }
        catch (InstantiationException exc) {
            throw new RuntimeException(exc, exc.getMessage(), this);
        }
    }

    public final Object createInstanceWithContext(XComponentContext xContext) throws com.sun.star.uno.Exception {
        return this.instantiate(xContext);
    }

    public final Object createInstanceWithArgumentsAndContext(Object[] arguments, XComponentContext xContext) throws com.sun.star.uno.Exception {
        Object inst = this.instantiate(xContext);
        XInitialization xInit = UnoRuntime.queryInterface(XInitialization.class, inst);
        if (null == xInit) {
            throw new IllegalArgumentException("cannot pass arguments to component; no XInitialization implemented!", this, 0);
        }
        xInit.initialize(arguments);
        return inst;
    }

    public final String getImplementationName() {
        return this.m_impl_name;
    }

    public final boolean supportsService(String service_name) {
        for (int nPos = 0; nPos < this.m_supported_services.length; ++nPos) {
            if (!this.m_supported_services[nPos].equals(service_name)) continue;
            return true;
        }
        return false;
    }

    public final String[] getSupportedServiceNames() {
        return this.m_supported_services;
    }
}

